import { ref } from 'vue';

export const notices = ref([]);

export function addNotice(noticeData, timeout = 3000) {
  const id = Date.now();
  const notice = { id, dismissible: true, ...noticeData };
  notices.value.push(notice);

  if (notice.dismissible && timeout > 0) {
    setTimeout(timeout => {
      dismissNotice(notice);
    }, timeout);
  }

  return notice;
}

export function dismissNotice(notice) {
  notices.value = notices.value.filter(singleNotice => singleNotice.id !== notice.id);
}
